<?php
require_once '../config/db.php';
require_once '../authorize.php';

// جلب الموظفين للفلترة
$users = $conn->query("SELECT id, name FROM users ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// استقبال الفلاتر
$filter_user = $_GET['employee_id'] ?? '';
$filter_from = $_GET['from'] ?? '';
$filter_to = $_GET['to'] ?? '';

// إعداد الاستعلام
$sql = "
  SELECT t.*, u.name AS employee_name 
  FROM employee_trainings t
  JOIN users u ON t.employee_id = u.id
  WHERE 1
";

$params = [];

if ($filter_user) {
  $sql .= " AND t.employee_id = ?";
  $params[] = $filter_user;
}

if ($filter_from) {
  $sql .= " AND t.course_date >= ?";
  $params[] = $filter_from;
}

if ($filter_to) {
  $sql .= " AND t.course_date <= ?";
  $params[] = $filter_to;
}

$sql .= " ORDER BY t.course_date DESC";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$trainings = $stmt->fetchAll(PDO::FETCH_ASSOC);

// جلب الدورات مع أسماء الموظفين
$stmt = $conn->query("
  SELECT t.*, u.name AS employee_name 
  FROM employee_trainings t
  JOIN users u ON t.employee_id = u.id
  ORDER BY t.course_date DESC
");
$trainings = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>سجل الدورات التدريبية</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-6xl mx-auto bg-white p-6 shadow rounded">
      <form method="GET" class="mb-4 bg-gray-100 p-4 rounded grid grid-cols-1 md:grid-cols-4 gap-4">
  <div>
    <label class="block mb-1 text-sm">الموظف</label>
    <select name="employee_id" class="w-full border p-2 rounded">
      <option value="">الكل</option>
      <?php foreach ($users as $user): ?>
        <option value="<?= $user['id'] ?>" <?= $filter_user == $user['id'] ? 'selected' : '' ?>>
          <?= htmlspecialchars($user['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div>
    <label class="block mb-1 text-sm">من تاريخ</label>
    <input type="date" name="from" value="<?= htmlspecialchars($filter_from) ?>" class="w-full border p-2 rounded">
  </div>

  <div>
    <label class="block mb-1 text-sm">إلى تاريخ</label>
    <input type="date" name="to" value="<?= htmlspecialchars($filter_to) ?>" class="w-full border p-2 rounded">
  </div>

  <div class="flex items-end">
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 w-full">🔍 تصفية</button>
  </div>
</form>

<style>.rtl-left{ margin-right:auto; }</style>

<div class="flex items-center gap-2 mb-4">
  <h2 class="text-2xl font-bold">📚 سجل الدورات التدريبية</h2>
  <a href="help_employee_trainings.php" target="_blank"
     class="rtl-left inline-flex items-center gap-2 px-3 py-1.5 rounded-xl bg-gray-200 text-gray-900 hover:bg-gray-300">
    ؟ تعليمات
  </a>
</div>

    <table class="w-full text-sm border">
      <thead class="bg-gray-200">
        <tr>
          <th class="p-2">الموظف</th>
          <th>اسم الدورة</th>
          <th>الجهة</th>
          <th>التاريخ</th>
          <th>الساعات</th>
          <th>ملاحظات</th>
          <th>📎 الشهادة</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($trainings as $t): ?>
          <tr class="border-b hover:bg-gray-50">
            <td class="p-2"><?= htmlspecialchars($t['employee_name']) ?></td>
            <td><?= htmlspecialchars($t['course_name']) ?></td>
            <td><?= htmlspecialchars($t['provider']) ?></td>
            <td><?= $t['course_date'] ?></td>
            <td><?= $t['hours'] ?> ساعة</td>
            <td><?= nl2br(htmlspecialchars($t['employee_feedback'])) ?></td>
            <td>
              <?php if ($t['certificate_path']): ?>
                <a href="../<?= $t['certificate_path'] ?>" target="_blank" class="text-blue-600 underline">عرض/تحميل</a>
              <?php else: ?>
                <span class="text-gray-500">لا يوجد</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
