<?php
session_start();
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'], ['admin', 'manager'])) {
    header("Location: ../unauthorized.php");
    exit;
}

$user = $_SESSION['user'];
$user_id = $user['id'];
$role = $user['role'];

// جب بيانات الطلب قبل التحديث عشان تعرف حالته والمديرين
$row = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['id'])) {
    $id = intval($_POST['id']);
    $stmt = $conn->prepare("SELECT * FROM asset_requests WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id   = intval($_POST['id'] ?? 0);
    $note = trim($_POST['note'] ?? '');
    $action = $_POST['action'] ?? '';
    $assigned_manager_id = isset($_POST['assigned_manager_id']) ? intval($_POST['assigned_manager_id']) : null;
    $approved_by_manager = isset($_POST['approved_by_manager']) ? intval($_POST['approved_by_manager']) : null;

    if (!$id || !in_array($action, ['accept', 'reject', 'ready'])) {
        $_SESSION['error'] = "بيانات غير صحيحة.";
        header("Location: index.php");
        exit;
    }

    // (1) موافقة الموارد البشرية: يحدد المدير المعتمد والمختص مع بعض ويرسل الطلب للمدير المعتمد مباشرة
    if ($action === 'accept' && $approved_by_manager && $assigned_manager_id && $row['status'] == 'بانتظار الموارد البشرية') {
        $status = 'بانتظار اعتماد المدير المعتمد';
        $stmt = $conn->prepare("
            UPDATE asset_requests 
            SET status = ?, approved_by_hr = ?, hr_notes = ?, approved_by_manager = ?, assigned_manager_id = ?
            WHERE id = ?
        ");
        $stmt->execute([$status, $user_id, $note, $approved_by_manager, $assigned_manager_id, $id]);
        $_SESSION['success'] = "تم تحويل الطلب للمدير المعتمد.";
    }
    // (2) موافقة المدير المعتمد: يرسل الطلب للمدير المختص تلقائي (بدون تحديد جديد)
    elseif ($action === 'accept' && $role == 'manager' && $row && $user_id == $row['approved_by_manager'] && $row['status'] == 'بانتظار اعتماد المدير المعتمد') {
        $status = 'بانتظار المدير المختص';
        $stmt = $conn->prepare("
            UPDATE asset_requests 
            SET status = ?, manager_notes = ?
            WHERE id = ?
        ");
        $stmt->execute([$status, $note, $id]);
        $_SESSION['success'] = "تم تحويل الطلب للمدير المختص.";
    }
    // (3) موافقة المدير المختص: "بانتظار التنفيذ"
    elseif ($action === 'ready' && $role == 'manager' && $row && $user_id == $row['assigned_manager_id'] && $row['status'] == 'بانتظار المدير المختص') {
        $status = 'بانتظار التنفيذ';
        $stmt = $conn->prepare("
            UPDATE asset_requests 
            SET status = ?, manager_notes = ?
            WHERE id = ?
        ");
        $stmt->execute([$status, $note, $id]);
        $_SESSION['success'] = "تم تجهيز العهدة.";
    }
    // رفض الطلب
    else {
        $status = 'مرفوضة';
        $stmt = $conn->prepare("
            UPDATE asset_requests 
            SET status = ?, hr_notes = ?
            WHERE id = ?
        ");
        $stmt->execute([$status, $note, $id]);
        $_SESSION['success'] = "تم رفض الطلب.";
    }

    header("Location: index.php");
    exit;
}

header("Location: index.php");
exit;
?>
