<?php
// /erp_task_system/leaves/update_leave_status.php
session_start();
require_once '../config/db.php';
require_once '../auth.php';

function hasColumn(PDO $conn, string $table, string $column): bool {
  $stmt = $conn->prepare("
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ?
  ");
  $stmt->execute([$table, $column]);
  return (bool)$stmt->fetchColumn();
}

if (!isset($_SESSION['user'])) { header("Location: ../unauthorized.php"); exit; }
$user = $_SESSION['user'];
$role = $user['role'] ?? '';
$userId = (int)($user['id'] ?? 0);
$userDeptId = (int)($user['department_id'] ?? 0);

// CSRF
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header("Location: requests.php"); exit; }
$csrf = $_POST['csrf'] ?? '';
if (!$csrf || !hash_equals($_SESSION['csrf_leave'] ?? '', $csrf)) {
  $_SESSION['error'] = "⚠️ انتهت صلاحية الجلسة. حدّث الصفحة وحاول مرة ثانية.";
  header("Location: requests.php"); exit;
}

$id     = (int)($_POST['id'] ?? 0);
$actor  = $_POST['actor'] ?? '';
$action = $_POST['action'] ?? ''; // accept | reject
$note   = trim($_POST['note'] ?? '');

if ($id <= 0 || !in_array($action, ['accept','reject'], true)) {
  $_SESSION['error'] = "طلب غير صالح.";
  header("Location: requests.php"); exit;
}

// جب الطلب + إدارة الموظف
$st = $conn->prepare("
  SELECT lr.*, u.department_id AS emp_dept_id
  FROM leave_requests lr
  JOIN users u ON u.id = lr.user_id
  WHERE lr.id = ?
");
$st->execute([$id]);
$req = $st->fetch(PDO::FETCH_ASSOC);
if (!$req) {
  $_SESSION['error'] = "الطلب غير موجود.";
  header("Location: requests.php"); exit;
}

// حدد هل المستخدم موارِد بشرية
$userDeptName = null;
if ($userDeptId > 0) {
  $q = $conn->prepare("SELECT name FROM departments WHERE id=?");
  $q->execute([$userDeptId]);
  $userDeptName = $q->fetchColumn() ?: null;
}
$hrNames = ['إدارة الموارد البشرية','الموارد البشرية','HR','Human Resources'];
$isHRDept = ($role === 'manager' && $userDeptName && in_array($userDeptName, $hrNames, true));
$isAdmin = ($role === 'admin');
$isManager = ($role === 'manager');

$empDeptId = (int)($req['emp_dept_id'] ?? 0);
$manager_status = $req['manager_status'] ?? null;
$hr_status = $req['hr_status'] ?? null;

// صلاحيات حسب actor
if ($actor === 'manager') {
  if (!$isManager || $empDeptId !== $userDeptId) {
    $_SESSION['error'] = "ما تملك صلاحية اعتماد هذا الطلب كمدير.";
    header("Location: requests.php"); exit;
  }
  if (!is_null($manager_status)) {
    $_SESSION['error'] = "تمت مراجعة المدير مسبقًا.";
    header("Location: requests.php"); exit;
  }
} elseif ($actor === 'hr') {
  if (!$isHRDept) {
    $_SESSION['error'] = "ما تملك صلاحية اعتماد هذا الطلب كموارد.";
    header("Location: requests.php"); exit;
  }
  if (!is_null($hr_status)) {
    $_SESSION['error'] = "تمت مراجعة الموارد مسبقًا.";
    header("Location: requests.php"); exit;
  }
} elseif ($actor === 'admin') {
  if (!$isAdmin) {
    $_SESSION['error'] = "صلاحية غير كافية.";
    header("Location: requests.php"); exit;
  }
  if (!is_null($hr_status)) {
    $_SESSION['error'] = "تمت مراجعة الموارد مسبقًا.";
    header("Location: requests.php"); exit;
  }
} else {
  $_SESSION['error'] = "نوع جهة الاعتماد غير معروف.";
  header("Location: requests.php"); exit;
}

// نحدّد القيَم الجديدة
$setManager = false; $setHR = false;
$new_manager_status = $manager_status;
$new_hr_status      = $hr_status;

if ($actor === 'manager') {
  $new_manager_status = ($action === 'accept') ? 'مقبولة' : 'مرفوضة';
  $setManager = true;
} else { // hr or admin
  $new_hr_status = ($action === 'accept') ? 'مقبولة' : 'مرفوضة';
  $setHR = true;
}

// حدّد الحالة النهائية الموحدة (status)
$final = 'pending';
if ($new_manager_status === 'مرفوضة' || $new_hr_status === 'مرفوضة') {
  $final = 'rejected';
} elseif ($new_manager_status === 'مقبولة' && $new_hr_status === 'مقبولة') {
  $final = 'approved';
} else {
  $final = 'pending';
}

// جهّز جملة التحديث مرنة حسب الأعمدة الموجودة
$cols = [];
$vals = [];
if ($setManager) { $cols[] = "manager_status = ?"; $vals[] = $new_manager_status; }
if ($setHR)      { $cols[] = "hr_status = ?";      $vals[] = $new_hr_status; }

if ($actor === 'manager') { $cols[] = "manager_note = ?"; $vals[] = $note; }
else                      { $cols[] = "hr_note = ?";      $vals[] = $note; }

// status (موحد بالإنجليزي عشان التكامل مع الرواتب)
if (hasColumn($conn, 'leave_requests', 'status')) {
  $cols[] = "status = ?"; $vals[] = $final;
}

// updated_at إن وجد
if (hasColumn($conn, 'leave_requests', 'updated_at')) {
  $cols[] = "updated_at = NOW()";
}

$vals[] = $id;

$sql = "UPDATE leave_requests SET ".implode(", ", $cols)." WHERE id = ?";
try {
  $up = $conn->prepare($sql);
  $up->execute($vals);

  // رسالة نجاح مفيدة
  if ($final === 'approved') {
    $_SESSION['success'] = "✅ تم اعتماد الطلب نهائيًا (مقبول).";
  } elseif ($final === 'rejected') {
    $_SESSION['success'] = "⛔ تم رفض الطلب.";
  } else {
    $_SESSION['success'] = ($actor==='manager')
      ? "تم تسجيل قرار المدير بنجاح."
      : "تم تسجيل قرار الموارد بنجاح.";
  }

} catch (Throwable $e) {
  $_SESSION['error'] = "فشل التحديث: ".$e->getMessage();
}

header("Location: requests.php");
exit;
