<?php
require_once '../config/db.php';

// فعّل الأخطاء مؤقتًا للتشخيص (احذفها بالإنتاج)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function tableExists(PDO $conn, string $table): bool {
  $q = $conn->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ?");
  $q->execute([$table]);
  return (bool)$q->fetchColumn();
}
function columnExists(PDO $conn, string $table, string $col): bool {
  $q = $conn->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ?");
  $q->execute([$table, $col]);
  return (bool)$q->fetchColumn();
}

$employee_id     = filter_input(INPUT_GET, 'employee_id', FILTER_VALIDATE_INT);
$evaluation_date = $_GET['evaluation_date'] ?? date('Y-m-d');
$period          = $_GET['evaluation_period'] ?? 'monthly';

if (!$employee_id || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $evaluation_date)) {
  exit('بيانات ناقصة أو تاريخ غير صحيح');
}

// احسب البداية والنهاية (شاملة يوم التقييم)
$endExclusive = date('Y-m-d', strtotime($evaluation_date . ' +1 day')); // < endExclusive
$start_date   = date(
  'Y-m-d',
  strtotime(($period === 'monthly' ? '-1 month' : '-6 months'), strtotime($evaluation_date))
);

// حدّد طريقة الربط بالموظف حسب بنية القاعدة
$join  = '';
$whereAssignee = '';
if (columnExists($conn, 'tasks', 'assigned_to')) {
  $whereAssignee = 't.assigned_to = :emp';
} elseif (tableExists($conn, 'task_users')) {
  $join = 'JOIN task_users tu ON tu.task_id = t.id';
  $whereAssignee = 'tu.user_id = :emp';
} else {
  exit('ما لقيت حقل/جدول يربط المهام بالموظف (assigned_to أو task_users).');
}

// حقول مساعدة
$dateExpr   = columnExists($conn, 'tasks', 'updated_at') ? 'COALESCE(t.updated_at, t.created_at)' : 't.created_at';
$deletedCond = columnExists($conn, 'tasks', 'is_deleted') ? ' AND IFNULL(t.is_deleted,0)=0 ' : '';

// الاستعلام
$sql = "
  SELECT
    t.id,
    t.title,
    ".(columnExists($conn,'tasks','status') ? 't.status' : 'NULL AS status').",
    $dateExpr AS activity_at
  FROM tasks t
  $join
  WHERE $whereAssignee
    $deletedCond
    AND $dateExpr >= :start
    AND $dateExpr <  :end
  ORDER BY activity_at DESC
";
$stmt = $conn->prepare($sql);
$stmt->execute([
  ':emp'   => $employee_id,
  ':start' => $start_date,
  ':end'   => $endExclusive,
]);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="p-4">
  <h3 class="text-lg font-bold mb-3">📌 مهام الموظف للفترة (<?= htmlspecialchars($start_date) ?> → <?= htmlspecialchars($evaluation_date) ?>)</h3>
  <?php if (!empty($tasks)): ?>
    <ul class="space-y-2 text-sm">
      <?php foreach ($tasks as $t): ?>
        <li class="border p-2 rounded bg-gray-50">
          <strong><?= htmlspecialchars($t['title'] ?? '—') ?></strong>
          <div class="text-gray-600">
            آخر نشاط: <?= htmlspecialchars($t['activity_at']) ?>
            <?php if (!is_null($t['status'])): ?> | الحالة: <?= htmlspecialchars($t['status']) ?><?php endif; ?>
          </div>
        </li>
      <?php endforeach; ?>
    </ul>
  <?php else: ?>
    <div class="text-gray-500">ما فيه مهام بهالفترة.</div>
  <?php endif; ?>
</div>
